* Poisson_plot.sas;
title "Plot probabilities for the Poisson distribution";
title2 "lambda = 2";
data poisson_plot;
	* Poisson parameter here;
	lambda = 2;
	* Maximum value of y for plot;
	ymax = 20;
	do y=0 to ymax;
		* Poisson distribution function;
		proby = pdf('poisson',y,lambda); 
		* Output y and proby to SAS data file;
		output;
	end;
run;
* Print data;
proc print data=poisson_plot;
run;
* Plot probabilities;
proc gplot data=poisson_plot;
	plot proby*y=1 / vref=0 wvref=3 vaxis=axis1 haxis=axis1;
	symbol1 i=needle v=dot c=red width=3 height=2;
	axis1 label=(height=2) value=(height=2) width=3 major=(width=2) minor=none;
run;
quit;
